<?php

require_once(dirname(__FILE__).'/../../GoToLightAPI.php');

class AdminGoToLightPickingController extends ModuleAdminController
{
	var $api;
	var $message;
	
	public function __construct()
	{
		$this->lang = true;
		$this->deleted = false;
		$this->colorOnBackground = false;
		$this->context = Context::getContext();
		
		// définition de l'upload, chemin par défaut _PS_IMG_DIR_
		$this->fieldImageSettings = array('name' => 'image', 'dir' => 'example');
		
		$this->api = new GoToLightAPI(Configuration::get('GOTOLIGHT_PICKING_API_URL_CONF'), Configuration::get('GOTOLIGHT_PICKING_API_USER_CONF'), Configuration::get('GOTOLIGHT_PICKING_API_PWD_CONF'));
		
		$this->message = "";
		
		parent::__construct();
	}
	
	/**
	 * Function used to render the list to display for this controller
	 */
	public function renderList()
	{
		$result = "";
		
		if (!$this->api->CheckConnectivity())
		{
			$result .= '<br><div class="alert alert-info"><b>Erreur lors de la connexion au serveur Go-to-Light. Merci de vérifier les paramètres.</b></div><br>'; 
		}
		
		if ($this->message != "")
		{
			$result .= "<h3>$this->message</h3>";
		}

		// Get the list of already exported orders
		$sqlOrdersAlreadyExported = "SELECT * FROM "._DB_PREFIX_."GoToLightPickingOrders";
		$ordersAlreadyExportedDS = Db::getInstance()->ExecuteS($sqlOrdersAlreadyExported);
		$ordersAE = array();
		foreach ($ordersAlreadyExportedDS as $oae) 
		{
			array_push($ordersAE, $oae["order_id"]);		
		}
	
		$sql = "SELECT a.`id_order`, c.firstname, c.lastname, ca.name as carrier FROM "._DB_PREFIX_.'orders a LEFT JOIN `'._DB_PREFIX_.'order_history` oh ON (oh.`id_order` = a.`id_order`) LEFT JOIN `'._DB_PREFIX_.'customer` c ON (a.`id_customer` = c.`id_customer`) INNER JOIN `'._DB_PREFIX_.'order_carrier` oc ON (oc.id_order = a.`id_order`) INNER JOIN `'._DB_PREFIX_.'carrier` ca ON (oc.id_carrier = ca.`id_carrier`)  WHERE (id_order_state = 3) AND a.valid = 1 AND oh.`id_order_history` = (SELECT MAX(`id_order_history`) FROM `'._DB_PREFIX_.'order_history` moh WHERE moh.`id_order` = a.`id_order` GROUP BY moh.`id_order`)';
		$orders = Db::getInstance()->ExecuteS($sql);
		
		if (sizeof($orders) > 0)
		{
			$result .= '<style type="text/css">
				table.sample {
					border-width: 1px;
					border-spacing: 0px;
					border-style: outset;
					border-color: gray;
					border-collapse: collapse;
					background-color: white;
				}
				table.sample th {
					border-width: 1px;
					padding: 4px;
					border-style: inset;
					border-color: gray;
					background-color: white;
					-moz-border-radius: ;
				}
				table.sample td {
					border-width: 1px;
					padding: 4px;
					border-style: inset;
					border-color: gray;
					background-color: white;
					-moz-border-radius: ;
				}
				</style>
				
				';


			$result .= '<br>Liste des commandes à exporter ayant le statut "<b>Pr&eacute;paration en cours</b>". <br><br>'; 
				
			$result .= '<form method="post" action="'.self::$currentIndex.'&token='.$this->token.'" class="form">';
			
			$result .= '<input type="submit" name="PickingSubmit" value="Exporter"><br><br>';
			
			$result .= '<table class="sample"><tr><th>Envoyer pour pr&eacute;paration</th><th>ID commande</th><th>Nom</th><th>Pr&eacute;nom</th><th>Transporteur</th></tr>';
		
			foreach ($orders as $tr) 
			{
				if (in_array($tr["id_order"], $ordersAE))
					continue;
				
				$result .= '<tr><td><input type="checkbox" checked name="id_order'.$tr["id_order"].'" Id="'.$tr["id_order"].'"></td>';
			    $result .= '<td>'.$tr["id_order"].'</td><td>'.$tr["firstname"].'</td><td>'.$tr["lastname"].'</td><td>' . $tr["carrier"] . '</td></tr>';
			}
			
			$result .= '</table><br><br><input type="submit" name="PickingSubmit" value="Exporter"></form>';
		}
		else
		{
			$result .= "Il n'y a actuellement pas de commandes avec le statut 'Pr&eacute;paration en cours'.";
		}
		
		return $result ;
	}
		
	/**
	 * method call when ajax request is made with the details row action
	 * @see AdminController::postProcess()
	 */
	public function ajaxProcessDetails()
	{
	}	
		
	public function renderForm()
	{
		return "";
		//return parent::renderForm();
	}
	
	private function startsWith($haystack, $needle)
	{
		$length = strlen($needle);
		return (substr($haystack, 0, $length) === $needle);
	}

	public function postProcess()
	{
		global $cookie;
			
		if (Tools::isSubmit('PickingSubmit')) 
		{
			$orders = array();
			
			 foreach ($_POST as $fieldName => $fieldValue) 
			 {
				if ($this->startsWith($fieldName, 'id_order') && $fieldValue == "on")
				 {				
					$id_order = substr($fieldName, 8, strlen($fieldName) - 8);
					array_push($orders, $id_order);
				 }
			 }
			
			$counter = 0;
			foreach ($orders as $idOrder) 
			{
				//$this->locationsByOrder[$idOrder] = $this->GetLocationsForOrder($idOrder);
				//usort($this->locationsByOrder[$idOrder], array($this, "cmpOrdersDetail"));

				// Export this ID
				if ($this->exportOrder($idOrder))
					$counter++;
			}
			
			$this->message = $counter . htmlspecialchars(" commande(s) exportée(s).");
		}	
	}
	
	function exportOrder($order_id)
	{
		// Extract elements of the order
		$rowDetail = Db::getInstance()->executeS('SELECT o.reference, od.product_ean13, od.product_id, od.product_attribute_id, c.firstname, c.lastname, od.product_quantity, od.product_name FROM '. _DB_PREFIX_.'order_detail od INNER JOIN '. _DB_PREFIX_.'orders o ON o.id_order = od.id_order INNER JOIN '. _DB_PREFIX_.'customer c ON c.id_customer = o.id_customer INNER JOIN '. _DB_PREFIX_.'product p ON p.id_product = od.product_id WHERE od.id_order = '.$order_id.' ORDER BY od.product_name');
		
		$ok = true;
		foreach ($rowDetail as $c => $d) 
		{
			$productRef = ($d["product_ean13"] == "" ? $d["product_id"] : $d["product_ean13"] );
						
			$orderInfo = $d["reference"] . ' ' . $d["firstname"]. ' ' . $d["lastname"];
						
			if (!$this->api->AddMissionDetail($order_id, $orderInfo, $productRef, $d["product_name"], $d["product_quantity"]))
				$ok = false;
		}
		
		if ($ok)
		{
			Db::getInstance()->Execute("INSERT INTO "._DB_PREFIX_."GoToLightPickingOrders (order_id) VALUES (". $order_id .")");
		}
		
		return $ok;
	}
}
