<?php


class GoToLightAPI {

   var $username;
   var $password;
   var $server;

   function __construct($server, $username, $password)
   {
       $this->username = $username;
       $this->password = $password;
	   $this->server = $server;
   }
   
   function request($command, $postData)
	{
		$json = json_encode( $postData ) ;

		$requestOpts = array(
			'http' => array(
				'method' => 'POST',
				'header'  =>    'Authorization: Basic ' . base64_encode("$this->username:$this->password")."\r\n".
								'Content-Type: application/json'."\r\n".
								'Content-Length: ' . strlen($json) . "\r\n",
								'Charset: utf-8'. "\r\n",
				'content' => $json
			)
		);
		
		$contextV = stream_context_create($requestOpts);
		$http_repV = file_get_contents($this->server . '/json/oneway/' . $command, false, $contextV);
	
		$data = json_decode($http_repV, true);
		
		return $data;
	}

	public function CheckConnectivity()
	{
		$result = $this->request("CheckConnectivity", "");
		return (is_array($result) && $result['Result'] == 'OK');
	}
	
	public function AddMissionDetail($orderID, $orderReference, $productReference, $productLabel, $qty)
	{
		$params = array(
			'MissionName' => $orderID,
			'MissionInfo' => $orderReference,
			'Reference' => $productReference,
			'Label' => $productLabel,
			'Quantity' => (int)$qty
		);

		$result = $this->request("MissionAddDetail", $params);
		
		return (is_array($result) && $result['Result'] == 'OK');
	}
}









