<?php
include('../../config/config.inc.php');
include('api_implementation.php');

function buildAnswer($result, $error)
{
	$answer = array();
	$answer['result'] = $result ? "true" : "false";
	$answer['error'] = $error;
	return json_encode($answer);
}

// 1. Check API key and pass-phrase first
if (!isset($_POST['api_key']))
	die(buildAnswer(false, 'Missing API Key'));

if (!isset($_POST['api_passphrase']))
	die(buildAnswer(false, 'Missing API Pass-phrase'));

if (!isset($_POST['action']))
	die(buildAnswer(false, 'Missing action'));

$param_api_key = $_POST['api_key'];
$param_api_passphrase = $_POST['api_passphrase'];
$param_action = $_POST['action'];
//$param_locale = $_POST['locale'];
//$param_connectorversion = $_POST['connectorversion'];

if (!Configuration::get('GOTOLIGHTCONNECTOR_APIKEY') || Configuration::get('GOTOLIGHTCONNECTOR_APIKEY') != $param_api_key)
	die(buildAnswer(false, 'Incorrect API key or pass-phrase'));

if (!Configuration::get('GOTOLIGHTCONNECTOR_APIPASSPHRASE') || Configuration::get('GOTOLIGHTCONNECTOR_APIPASSPHRASE') != $param_api_passphrase)
	die(buildAnswer(false, 'Incorrect API key or pass-phrase'));	
 
// __________________________________________________________________________________
// __________________________________________________________________________________
// __________________________________________________________________________________
//									API
 	
if ($param_action == "testConnectivity")
	die(buildAnswer(true, ""));	

	
if ($param_action == "GetRecentMissionNames")
{
	die(API_GetRecentMissionNames());
}
if ($param_action == "GetRecentCancelledMissionNames")
{
	die(API_GetRecentCancelledMissionNames());
}
if ($param_action == "GetMissionsByNames")
{
	$missionNames = $_POST['Names']; 
	die(API_GetMissionsByNames($missionNames));
}	
if ($param_action == "GetStock")
{
	die(API_GetStock());
}
if ($param_action == "GetColissimoSettings")
{
	die(API_GetColissimoSettings());
}
if ($param_action == "GetDHLSettings")
{
	die(API_GetDHLSettings());
}
if ($param_action == "SetStockLocation")
{
	$psiJSON = $_POST['ProductStockInfo'];
	
	if (isset($psiJSON))
	{
		API_SetStockLocation($psiJSON);		
		die(buildAnswer(true, ""));	
	}
	else
	{
		die(buildAnswer(false, "Missing ProductStockInfo"));	
	}
}
if ($param_action == "SetStockWeight")
{
	$psiJSON = $_POST['ProductStockInfo'];
	
	if (isset($psiJSON))
	{
		API_SetStockWeight($psiJSON);		
		die(buildAnswer(true, ""));	
	}
	else
	{
		die(buildAnswer(false, "Missing ProductStockInfo"));	
	}
} 
if ($param_action == "SetStockAbsoluteQuantity")
{
	$psiJSON = $_POST['ProductStockInfo'];
	
	if (isset($psiJSON))
	{
		API_SetStockAbsoluteQuantity($psiJSON);
		die(buildAnswer(true, ""));	
	}
	else
	{
		die(buildAnswer(false, "Missing ProductStockInfo"));	
	}
}	
if ($param_action == "SetStockDeltaQuantity")
{
	$psiJSON = $_POST['ProductStockInfo'];

	if (isset($psiJSON))
	{
		API_SetStockDeltaQuantity($psiJSON);
		die(buildAnswer(true, ""));	
	}
	else
	{
		die(buildAnswer(false, "Missing ProductStockInfo"));	
	}
}
if ($param_action == "SetStockEan")
{
	$psiJSON = $_POST['ProductStockInfo'];
	
	if (isset($psiJSON))
	{
		API_SetStockEan($psiJSON);		
		die(buildAnswer(true, ""));	
	}
	else
	{
		die(buildAnswer(false, "Missing ProductStockInfo"));	
	}
}  
if ($param_action == "SetMissionTrackingNumber")
{
	$MissionID = $_POST['MissionID'];
	$TrackingNumber = $_POST['TrackingNumber'];
	
	if (!isset($MissionID))
	{
		die(buildAnswer(false, "Missing MissionID"));
	}
	
	if (!isset($TrackingNumber))
	{
		die(buildAnswer(false, "Missing TrackingNumber"));
	}
	
	API_SetMissionTrackingNumber($MissionID, $TrackingNumber);		
	die(buildAnswer(true, ""));	
} 
if ($param_action == "StartMissions") {
	
	$missionIds = json_decode($_POST['MissionIDs']);
	$employee = json_decode($_POST['Employee']);
    die(API_StartMissions($missionIds, $employee));
}
if ($param_action == "EndMissions") {
	$missionIds = json_decode($_POST['MissionIDs']);
    die(API_EndMissions($missionIds));
}
if ($param_action == "PartialEndMissions") {
	$missionIds = json_decode($_POST['MissionIDs']);
    die(API_PartialEndMissions($missionIds));
}
	
die(buildAnswer(false, "Nothing to do"));	