﻿
using GoToLightAPI;
using GoToLightAPIExample.Properties;
using ServiceStack;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace GoToLightAPIExample
{
    public partial class MainForm : Form
    {
        private FileSystemWatcher m_watcher;

        public MainForm()
        {
            InitializeComponent();

            tbxAPIUrl.Text = Settings.Default.APIUrl;
            tbxUser.Text = Settings.Default.APIUsername;
            tbxPwd.Text = Settings.Default.APIPassword;
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            
        }

        private void btnTestConnexion_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                APIUsage.TestConnection(tbxAPIUrl.Text, tbxUser.Text, tbxPwd.Text);
                MessageBox.Show("Connection successful!", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            Cursor.Current = Cursors.Default;
        }

       

        private void tbxAPIUrl_TextChanged(object sender, EventArgs e)
        {
            Settings.Default.APIUrl = tbxAPIUrl.Text;
            Settings.Default.Save();
        }

        private void tbxUser_TextChanged(object sender, EventArgs e)
        {
            Settings.Default.APIUsername = tbxUser.Text;
            Settings.Default.Save();
        }

        private void tbxPwd_TextChanged(object sender, EventArgs e)
        {
            Settings.Default.APIPassword = tbxPwd.Text;
            Settings.Default.Save();
        }

        private void btnShowPosition_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                APIUsage.Show(tbxAPIUrl.Text, tbxUser.Text, tbxPwd.Text, tbxPosition.Text, "#FFFFFF", true, false);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            Cursor.Current = Cursors.Default;
        }
    }
}
