﻿using GoToLightAPI;
using ServiceStack;
using System;
using System.Collections.Generic;

namespace GoToLightAPIExample
{
    class APIUsage
    {
        public static void TestConnection(string apiURL, string username, string pwd)
        {
            var client = new JsonServiceClient(apiURL);
            client.SetCredentials(username, pwd);

            StandardResponse response = client.Post<StandardResponse>(new CheckConnectivity {});

            if (!String.IsNullOrEmpty(response.Error))
                throw new Exception("API Error: " + response.Error);
        }

        public static List<Position> Show(string apiURL, string username, string pwd, string key, string color, bool blink, bool persistant)
        {
            var client = new JsonServiceClient(apiURL);
            client.SetCredentials(username, pwd);

            List<Position> response = client.Post<List<Position>>(new Show { Key = key, Color = color, Blink = blink, Persistant = persistant});
            return response;
        }
    }
}
