<?php

require_once('GoToLightAPI.php');

// Security
if (!defined('_PS_VERSION_'))
	exit;
	
// Checking compatibility with older PrestaShop and fixing it
if (!defined('_MYSQL_ENGINE_'))
	define('_MYSQL_ENGINE_', 'MyISAM');

class GoToLightPicking extends Module
{			
  public function __construct()
  {  		  	
		// Author of the module
	$this->author = 'Pickeos SAS'; 
  	// Name of the module ; the same that the directory and the module ClassName
	  $this->name = 'gotolightpicking';
	  // Tab where it's the module (administration, front_office_features, ...)
	  $this->tab = 'shipping_logistics';
	  // Current version of the module
	  $this->version = '1.0.1';
	  
	  // Min version of PrestaShop wich the module can be install
	  $this->ps_versions_compliancy['min'] = '1.5';
	  // Max version of PrestaShop wich the module can be install
	  $this->ps_versions_compliancy['max'] = '1.6';
	  // OR $this->ps_versions_compliancy = array('min' => '1.5', 'max' => '1.6');
		
		// 	The need_instance flag indicates whether to load the module's class when displaying the "Modules" page 
		//	in the back-office. If set at 0, the module will not be loaded, and therefore will spend less resources 
		//	to generate the page module. If your modules needs to display a warning message in the "Modules" page, 
		//	then you must set this attribute to 1.
		$this->need_instance = 0; 
		
		// Modules needed for install
		$this->dependencies = array();
		// e.g. $this->dependencies = array('blockcart', 'blockcms');
		
		// Limited country 
		$this->limited_countries = array(); 
		// e.g. $this->limited_countries = array('fr', 'us');
					
	  parent::__construct();
		
		// Name in the modules list
		$this->displayName = $this->l('Go-to-Light Picking');
		// A little description of the module
	  $this->description = $this->l('Préparation de commande ultra rapide avec Go-to-Light de Pickeos. Picking avec PDA et guidage lumineux');
	  	  
	  // Message show when you wan to delete the module	  
		$this->confirmUninstall = $this->l('Etes-vous certain de vouloir supprimer ce module ?');
	  
	  if ($this->active && Configuration::get('BULDORDERPREPARING_CONF') == '')
			$this->warning = $this->l('Le module doit être configuré');
  }
  
	public function install()
	{
		// Install SQL
		include(dirname(__FILE__).'/sql/install.php');
		foreach ($sql as $s)
			if (!Db::getInstance()->execute($s))
				return false;
								
		// Install Tabs
		$parent_tab = new Tab();
		// Need a foreach for the language
		$parent_tab->name[$this->context->language->id] = $this->l('Préparation de commande Go-to-Light');
		$parent_tab->class_name = 'AdminGoToLightPicking';
		$parent_tab->id_parent = 10; // Home tab
		$parent_tab->module = $this->name;
		$parent_tab->add();		
				
		//Init
		Configuration::updateValue('GOTOLIGHT_PICKING_INIT_CONF', '0');	
		Configuration::updateValue('GOTOLIGHT_PICKING_API_URL_CONF', '');
		Configuration::updateValue('GOTOLIGHT_PICKING_API_USER_CONF', '');
		Configuration::updateValue('GOTOLIGHT_PICKING_API_PWD_CONF', '');
		
		// Install Module  
		// In this part, you don't need to add a hook in database, even if it's a new one. 
		// The registerHook method will do it for your !		
		return parent::install()
		&& $this->registerHook('actionObjectExampleDataAddAfter');		
  }    
  
  public function uninstall()
	{
		// Uninstall SQL
		include(dirname(__FILE__).'/sql/uninstall.php');
		foreach ($sql as $s)
			if (!Db::getInstance()->execute($s))
				return false;
	
		Configuration::deleteByName('GOTOLIGHT_PICKING_INIT_CONF');	
		Configuration::deleteByName('GOTOLIGHT_PICKING_API_URL_CONF');
		Configuration::deleteByName('GOTOLIGHT_PICKING_API_USER_CONF');
		Configuration::deleteByName('GOTOLIGHT_PICKING_API_PWD_CONF');

		// Uninstall Tabs
		$tab = new Tab((int)Tab::getIdFromClassName('AdminGoToLightPicking'));
		$tab->delete();
		
		// Uninstall Module
		if (!parent::uninstall())
			return false;
			
		// You don't need to call this one because uninstall do it for you
		// !$this->unregisterHook('actionObjectExampleDataAddAfter')

		return true;
	}
	
	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submit'.ucfirst($this->name)))
		{
			$GOTOLIGHT_PICKING_API_URL_CONF = Tools::getValue('GOTOLIGHT_PICKING_API_URL_CONF');
			$GOTOLIGHT_PICKING_API_USER_CONF = Tools::getValue('GOTOLIGHT_PICKING_API_USER_CONF');
			$GOTOLIGHT_PICKING_API_PWD_CONF = Tools::getValue('GOTOLIGHT_PICKING_API_PWD_CONF');
			
			Configuration::updateValue('GOTOLIGHT_PICKING_INIT_CONF', "1");
			Configuration::updateValue('GOTOLIGHT_PICKING_API_URL_CONF', $GOTOLIGHT_PICKING_API_URL_CONF);
			Configuration::updateValue('GOTOLIGHT_PICKING_API_USER_CONF', $GOTOLIGHT_PICKING_API_USER_CONF);
			Configuration::updateValue('GOTOLIGHT_PICKING_API_PWD_CONF', $GOTOLIGHT_PICKING_API_PWD_CONF);
			
			if (isset($errors) && count($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Paramètres mis à jour.'));
		}
		else if (Tools::isSubmit('testConnection'))
		{
			
			$api = new GoToLightAPI(Tools::getValue('GOTOLIGHT_PICKING_API_URL_CONF'), Tools::getValue('GOTOLIGHT_PICKING_API_USER_CONF'), Tools::getValue('GOTOLIGHT_PICKING_API_PWD_CONF'));
			
			if ($api->CheckConnectivity())
				$output .= $this->displayConfirmation($this->l('Test de connexion réussi.'));
			else
				$output .= $this->displayError($this->l('Erreur lors de la connexion. Merci de vérifier les paramètres.'));
		}
		
		return $output.$this->displayForm();
	}
	
	public function displayForm()
	{		
		if(isset($errors))
			$this->context->smarty->assign('errors', $errors);
		else
			$errors = array();
		
		$this->context->smarty->assign('request_uri', Tools::safeOutput($_SERVER['REQUEST_URI']));
		$this->context->smarty->assign('path', $this->_path);
		
		$this->context->smarty->assign('GOTOLIGHT_PICKING_API_URL_CONF', pSQL(Tools::getValue('GOTOLIGHT_PICKING_API_URL_CONF', Configuration::get('GOTOLIGHT_PICKING_API_URL_CONF'))));
		$this->context->smarty->assign('GOTOLIGHT_PICKING_API_USER_CONF', pSQL(Tools::getValue('GOTOLIGHT_PICKING_API_USER_CONF', Configuration::get('GOTOLIGHT_PICKING_API_USER_CONF'))));
		$this->context->smarty->assign('GOTOLIGHT_PICKING_API_PWD_CONF', pSQL(Tools::getValue('GOTOLIGHT_PICKING_API_PWD_CONF', Configuration::get('GOTOLIGHT_PICKING_API_PWD_CONF'))));
		$this->context->smarty->assign('submitName', 'submit'.ucfirst($this->name));
		$this->context->smarty->assign('errors', $errors);
		
		// You can return html, but I prefer this new version: use smarty in admin, :)
		return $this->display(__FILE__, 'views/templates/admin/configure.tpl');
	}
		
	public function hookActionObjectExampleDataAddAfter($params)
	{
		// Do something here...
		// ...
		return true;
	}
}
