<?php

class AdminBulkLocationUpdateController extends ModuleAdminController
{
	public function __construct()
	{
		$this->table = 'example_data';
		$this->className = 'ExampleData';
		$this->lang = true;
		$this->deleted = false;
		$this->colorOnBackground = false;
		$this->bulk_actions = array('delete' => array('text' => $this->l('Delete selected'), 'confirm' => $this->l('Delete selected items?')));
		$this->context = Context::getContext();
		
		// définition de l'upload, chemin par défaut _PS_IMG_DIR_
		$this->fieldImageSettings = array('name' => 'image', 'dir' => 'example');
		
		parent::__construct();
	}
	
	/**
	 * Function used to render the list to display for this controller
	 */
	public function renderList()
	{
		$result = "";

		global $currentIndex;

		$products = Db::getInstance()->ExecuteS('SELECT p.id_product, pl.name, p.quantity, p.location, p.reference, p.ean13, (SELECT COUNT(pa.id_product_attribute) FROM '._DB_PREFIX_.'product_attribute pa WHERE p.id_product = pa.id_product) AS attributes FROM '._DB_PREFIX_.'product p 
		LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (pl.`id_product` = p.`id_product`) 
		WHERE pl.id_lang = 1 AND p.active = 1 ORDER BY p.location, pl.name');
		
		if (sizeof($products))
		{
			$result .= '<style type="text/css">
				table.sample {
					border-width: 1px;
					border-spacing: 0px;
					border-style: outset;
					border-color: gray;
					border-collapse: collapse;
					background-color: white;
				}
				table.sample th {
					border-width: 1px;
					padding: 4px;
					border-style: inset;
					border-color: gray;
					background-color: white;
					-moz-border-radius: ;
				}
				table.sample td {
					border-width: 1px;
					padding: 4px;
					border-style: inset;
					border-color: gray;
					background-color: white;
					-moz-border-radius: ;
				}
				</style>
				
				';
				
			$result .= '<form method="post" action="'.$currentIndex.'&token='.$this->token.'" class="form">';

			$result .= '<table class="sample"><tr><th>ID produit</th><th>Designation</th><th>Reference</th><th>Emplacement</th><th>Nouvel emplacement de stock</th></tr>';
		
			foreach ($products as $key => $product) 
			{
					$result .= '<tr><td>'.$product["id_product"].'</td><td>'.$product["name"].'</td><td>'.$product["reference"].'</td><td>'.$product["location"]. '</td><td><input type="text" name="Location'.$product["id_product"].'" Id="LOC'.$product["id_product"].'"></td></tr>';									
			}
			$result .= '</table><br><br><input type="submit" name="BulkQtySubmit" value="Valider"></form>';
		}
		else
		{
			$result .= "Il n'y a actuellement pas de produits.";
		}

		return $result ;
	}
		
	
		
	public function renderForm()
	{
		return "";

		//return parent::renderForm();
	}
	
	private function startsWith($haystack, $needle)
	{
		$length = strlen($needle);
		return (substr($haystack, 0, $length) === $needle);
	}
	
	public function postProcess()
	{
		global $cookie;
			
		if (Tools::isSubmit('BulkQtySubmit')) 
		{
			foreach ($_POST as $fieldName => $fieldValue) 
			{
				if ($this->startsWith($fieldName, 'Location') && $fieldValue != "")
				{				
					$id_product = substr($fieldName, 8, strlen($fieldName) - 8);
					$location = trim($fieldValue);
					
					// Enregistrement location
					Db::getInstance()->Execute('UPDATE '. _DB_PREFIX_."product SET location='". $location ."' WHERE id_product = ".$id_product);
				}
			}
		}
		
		parent::postProcess();	
	}
}
