<?php
if (!defined('_PS_VERSION_'))
    exit;

class GoToLightConnector extends Module
{
    public function __construct()
    {
        $this->name = 'gotolightconnector';
        $this->tab = 'shipping_logistics';
        $this->version = '1.2.0';
        $this->author = 'Pickeos SAS';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Go-to-Light Connector');
        $this->description = $this->l('Connector to use barcode scanners for the picking and stock operations');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        if (!Configuration::get('GOTOLIGHTCONNECTOR'))
            $this->warning = $this->l('No name provided');
		
		// Check if was an update and make sure db is up to date
		$this->_installSqlIfNeeded();
    }

    private function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function install()
    {
        if (Shop::isFeatureActive())
            Shop::setContext(Shop::CONTEXT_ALL);

        // Generate API KEY
        $apiKey = $this->generateRandomString(12);
        $apiKey = strtoupper($apiKey);

        $apiPassphrase = $this->generateRandomString(8);

        // Install Tabs
        $parent_tab = new Tab();
        // Need a foreach for the language
        $parent_tab->name[$this->context->language->id] = $this->l('Emplacements de stock');
        $parent_tab->class_name = 'AdminBulkLocationUpdate';
        $parent_tab->id_parent = 9; // Catalog
        $parent_tab->module = $this->name;
        $parent_tab->add();

        if (!parent::install() ||
			!$this->_installSqlIfNeeded() ||
			!$this->registerHook('displayAdminProductsQuantitiesStepBottom') ||	 
            !$this->registerHook('adminOrder') ||			
            !Configuration::updateValue('GOTOLIGHTCONNECTOR', 'GoToLightConnector') ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_APIKEY', $apiKey) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_REFERENCETYPE', 0) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT', 3) ||
			!Configuration::updateValue('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT', 0) ||
			!Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2', 4) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY', 0) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY', 0) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT', 0) ||
			!Configuration::updateValue('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS', 1) ||
            !Configuration::updateValue('GOTOLIGHTCONNECTOR_APIPASSPHRASE', $apiPassphrase) ||
			!Configuration::updateValue('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED', 0) ||
			!Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED', 4)
        )
            return false;

        return true;
    }

	protected function _installSqlIfNeeded() {
		
		if (!Db::getInstance()->Execute("CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."gotolightconnector_order_status` (
                              `id_order` int(10) unsigned DEFAULT NULL,
                              `status` tinyint(2) unsigned DEFAULT NULL,
                              `date_start` datetime DEFAULT NULL,
                              `date_finish` datetime DEFAULT NULL,
                              `employee` varchar(32) DEFAULT NULL
                            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;")) {
            return false;
        }
							
		$sqlInstall =  "SET @dbname = DATABASE();
		SET @tablename = '" . _DB_PREFIX_ . "product';
		SET @columnname = 'qtyproductperpackage';
		SET @preparedStatement = (SELECT IF(
		  (
			SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
			WHERE
			  (table_name = @tablename)
			  AND (table_schema = @dbname)
			  AND (column_name = @columnname)
		  ) > 0,
		  'SELECT 1',
		  CONCAT('ALTER TABLE " . _DB_PREFIX_ . "product ADD qtyproductperpackage TEXT NULL, ADD gtinpackage TEXT NULL')
		));
		PREPARE alterIfNotExists FROM @preparedStatement;
		EXECUTE alterIfNotExists;
		DEALLOCATE PREPARE alterIfNotExists;";
		
		$returnSql = Db::getInstance()->execute($sqlInstall);
		if (!$returnSql)
			return false;
		
		$sqlInstall =  "SET @dbname = DATABASE();
		SET @tablename = '" . _DB_PREFIX_ . "product';
		SET @columnname = 'qtyproductperpackage2';
		SET @preparedStatement = (SELECT IF(
		  (
			SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
			WHERE
			  (table_name = @tablename)
			  AND (table_schema = @dbname)
			  AND (column_name = @columnname)
		  ) > 0,
		  'SELECT 1',
		  CONCAT('ALTER TABLE " . _DB_PREFIX_ . "product ADD qtyproductperpackage2 TEXT NULL, ADD gtinpackage2 TEXT NULL')
		));
		PREPARE alterIfNotExists FROM @preparedStatement;
		EXECUTE alterIfNotExists;
		DEALLOCATE PREPARE alterIfNotExists;";
		
		$returnSql = Db::getInstance()->execute($sqlInstall);

		return $returnSql;
	}

    public function uninstall()
	{
        if (!parent::uninstall() ||
		  !$this->_unInstallSql() ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_APIKEY') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_REFERENCETYPE') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT') ||
		  !Configuration::deleteByName('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT') ||
		  !Configuration::deleteByName('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT') ||
		  !Configuration::deleteByName('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS') ||
          !Configuration::deleteByName('GOTOLIGHTCONNECTOR_APIPASSPHRASE') ||
		  !Configuration::deleteByName('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED') ||
		  !Configuration::deleteByName('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED')
        )
            return false;
        return true;
	}

	protected function _unInstallSql() {
		
		if (!Db::getInstance()->Execute('DROP TABLE ' . _DB_PREFIX_ . 'gotolightconnector_order_status')) {
            return false;
        }
		
		$sqlInstall = "ALTER TABLE " . _DB_PREFIX_ . "product DROP qtyproductperpackage, DROP gtinpackage, DROP qtyproductperpackage2, DROP gtinpackage2";
		$returnSql = Db::getInstance()->execute($sqlInstall);

		return $returnSql;
	}
		
	//public function hookDisplayAdminProductsMainStepLeftColumnMiddle($params) {
	public function hookDisplayAdminProductsQuantitiesStepBottom($params) {
		$product = new Product($params['id_product']);

		$this->context->smarty->assign(array(
		  'qtyproductperpackage' => $product->qtyproductperpackage,
		  'gtinpackage' => $product->gtinpackage,
		  'qtyproductperpackage2' => $product->qtyproductperpackage2,
		  'gtinpackage2' => $product->gtinpackage2,		  
		));

		return $this->display(__FILE__, 'views/templates/hook/admin/product/extra_fields.tpl');
	}

	public function hookAdminOrder($params)
    {
        if(!isset($_GET['id_order']))
			return '';
	
		$this->_html = "";
	
		$order=new Order(intval($_GET['id_order']));

        // Read value from DB
        $sql  = 'SELECT * FROM `'._DB_PREFIX_.'gotolightconnector_order_status` mos WHERE mos.id_order = ' . $order->id;
        $orderPrep = Db::getInstance()->getRow($sql);
        
        if (count($orderPrep) > 1) {
            if ($orderPrep['status'] == 2) {
                $this->_html .='
                
                   <div class="row">
                    <div class="col-lg-12">
                    <div class="panel">
                    <table>
                    <tr>
                    <td>'.$this->l('Picking').': '.$this->l(' end of picking by ').' '. $orderPrep['employee'].' on the '. $orderPrep['date_finish'].$this->l(' and started on the ').
                    $orderPrep['date_start'].' </td>
                    </tr></table>
                    </div>
                   </div>';
            } 
			elseif ($orderPrep['status'] == 3) {
                $this->_html .='
                
                   <div class="row">
                    <div class="col-lg-12">
                    <div class="panel">
                    <table>
                    <tr>
                    <td>'.$this->l('Picking').': '.$this->l('Partial end of picking (not complete) by ').' '. $orderPrep['employee'].' on the '. $orderPrep['date_finish'].$this->l(' and started on the ').
                    $orderPrep['date_start'].' </td>
                    </tr></table>
                    </div>
                   </div>';
            }			
			elseif ($orderPrep['status'] == 1) {
                $this->_html .='
                   <div class="row">
                    <div class="col-lg-12">
                    <div class="panel">
                    <table>
                    <tr>
                    <td>'.$this->l('Picking').': '.$this->l(' started by ').' '. $orderPrep['employee'] .' on the '. $orderPrep['date_start'].'</td>
                    </tr></table>
                    </div>
                   </div>';
            }
        }

        return $this->_html;
    }

	public function getContent()
	{
		$output = null;

		if (Tools::isSubmit('submit'.$this->name))
		{
			$referenceType = strval(Tools::getValue('GOTOLIGHTCONNECTOR_REFERENCETYPE'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_REFERENCETYPE', $referenceType);

			$orderStatusToexport = strval(Tools::getValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT', $orderStatusToexport);
			
			$orderStatusToexport2 = strval(Tools::getValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2', $orderStatusToexport2);

			$addOrderStatusToExport = strval(Tools::getValue('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT', $addOrderStatusToExport);

			$orderExcludeOneQuantity = strval(Tools::getValue('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY', $orderExcludeOneQuantity);

			$orderExcludeQuantity = strval(Tools::getValue('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY', $orderExcludeQuantity);

			$orderExcludeWeight = strval(Tools::getValue('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT', $orderExcludeWeight);

			$orderStockExcludeNonActiveProduct = strval(Tools::getValue('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS', $orderStockExcludeNonActiveProduct);

			$orderStatusWhenPrepared = strval(Tools::getValue('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED', $orderStatusWhenPrepared);

			$changeOrderStatusWhenPrepared = strval(Tools::getValue('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED'));
			Configuration::updateValue('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED', $changeOrderStatusWhenPrepared);
			

			$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		return $output.$this->displayConfiguration();
	}

	public function displayConfiguration()
	{
		$module_url = Tools::getProtocol(Tools::usingSecureMode()).$_SERVER['HTTP_HOST'].$this->getPathUri();

		$this->context->smarty->assign(array(
		'api_key' => Configuration::get('GOTOLIGHTCONNECTOR_APIKEY'),
		'api_passphrase' => Configuration::get('GOTOLIGHTCONNECTOR_APIPASSPHRASE'),
		'api_url' => $module_url."api.php",
		));

		$html = $this->display(__FILE__, '/views/templates/admin/admin.tpl');

		$referenceType = (int)Configuration::get('GOTOLIGHTCONNECTOR_REFERENCETYPE');

		$options = array(
		  array(
			'id_option' => 0,                 // The value of the 'value' attribute of the <option> tag.
			'name' => 'Product reference'              // The value of the text content of the  <option> tag.
		  ),
		  array(
			'id_option' => 1,
			'name' => 'EAN code'
		  ),
		);


		$orderStatusOptions = array();
		$possibleOrderStatus = Db::getInstance()->executeS('SELECT * FROM '. _DB_PREFIX_.'order_state_lang WHERE id_lang = '.Configuration::get('PS_LANG_DEFAULT'));
		foreach ($possibleOrderStatus as $pos)
		{
            $orderStatusOptions[] = array(
              "id" => (int)$pos['id_order_state'],
              "name" => $pos['name']
            );
		}

        // Init Fields form array
		$fields_form[0]['form'] = array(
			'legend' => array(
				'title' => $this->l('Paramètres'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('Type of reference to be used:'),
					'name' => 'GOTOLIGHTCONNECTOR_REFERENCETYPE',
					'size' => 1,
					'required' => true,
					'options' => array(
						'query' => $options,
						'id' => 'id_option',
						'name' => 'name'
					  )
				),
				array(
					'type' => 'select',
					'label' => $this->l('Order status to be exported:'),
					'name' => 'GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT',
					'size' => 1,
					'required' => true,
					'options' => array(
						'query' => $orderStatusOptions,
						'id' => 'id',
						'name' => 'name'
					  )
				),
				array(
						'type' => 'switch',
						'label' => $this->l('Add order status to be exported.'),
						'name' => 'GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT',
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Disabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Enabled')
									)
								),
						'options' => array(
						'query' => $addOrderStatusToExport,
						'id' => 'id_add_order_status_to_export',
						'name' => 'name_add_order_status_to_export'
					  )
					),
				array(
					'type' => 'select',
					'label' => $this->l('Second order status to be exported:'),
					'name' => 'GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2',
					'size' => 1,
					'required' => false,
					'options' => array(
						'query' => $orderStatusOptions,
						'id' => 'id',
						'name' => 'name'
					  )
				),
				array(
						'type' => 'switch',
						'label' => $this->l('Change order status when order is prepared.'),
						'name' => 'GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED',
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Disabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Enabled')
									)
								),
						'options' => array(
						'query' => $changeOrderStatusWhenPrepared,
						'id' => 'id_change_order_status_when_prepared',
						'name' => 'name_change_order_status_when_prepared'
					  )
					),
				array(
					'type' => 'select',
					'label' => $this->l('Order status to set when order is prepared:'),
					'name' => 'GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED',
					'size' => 1,
					'required' => false,
					'options' => array(
						'query' => $orderStatusOptions,
						'id' => 'id',
						'name' => 'name'
					  )
				),
				array(
						'type' => 'switch',
						'label' => $this->l('Exclude command(s) having only one product.'),
						'name' => 'GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY',
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Disabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Enabled')
									)
								),
						'options' => array(
						'query' => $orderStatusExcludeOneQuantity,
						'id' => 'id_exclude_onequantity',
						'name' => 'name_exclude_onequantity'
					  )
					),
				array(
						'type' => 'text',
						'label' => $this->l('Exclude command(s) having more than this quantity (0: disabled). '),
						'name' => 'GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY',
						'class' => 'fixed-width-xs',
						'options' => array(
						'query' => $orderStatusExcludeQuantity,
						'id' => 'id_exclude_quantity',
						'name' => 'name_exclude_quantity'
					  )
					),
				array(
						'type' => 'text',
						'label' => $this->l('Exclude command(s) having more than this weight (kg) (0: disabled).'),
						'name' => 'GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT',
						'class' => 'fixed-width-xs',
						'options' => array(
						'query' => $orderStatusExcludeWeight,
						'id' => 'id_exclude_weight',
						'name' => 'name_exclude_weight'
					  )
					),
				array(
						'type' => 'switch',
						'label' => $this->l('STOCK: synchronize only active products.'),
						'name' => 'GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS',
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Disabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Enabled')
									)
								),
						'options' => array(
						'query' => $orderStockExcludeNonActiveProduct,
						'id' => 'id_exclude_nonactiveproducts',
						'name' => 'name_exclude_nonactiveproducts'
					  )
					),					
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$helper = new HelperForm();

		// Module, token and currentIndex
		$helper->module = $this;
		$helper->name_controller = $this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

		// Language
		$helper->default_form_language = $default_lang;
		$helper->allow_employee_form_lang = $default_lang;

		// Title and toolbar
		$helper->title = $this->displayName;
		$helper->show_toolbar = true;        // false -> remove toolbar
		$helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
		$helper->submit_action = 'submit'.$this->name;
		$helper->toolbar_btn = array(
			'save' =>
			array(
				'desc' => $this->l('Save'),
				'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
				'&token='.Tools::getAdminTokenLite('AdminModules'),
			),
			'back' => array(
				'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc' => $this->l('Back to list')
			)
		);

		// Load current value
		$helper->fields_value['GOTOLIGHTCONNECTOR_REFERENCETYPE'] = Configuration::get('GOTOLIGHTCONNECTOR_REFERENCETYPE');
		$helper->fields_value['GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT'] = Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT');
		$helper->fields_value['GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2'] = Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2');
		$helper->fields_value['GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT'] = Configuration::get('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT');
		$helper->fields_value['GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY'] = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY');
		$helper->fields_value['GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY'] = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY');
		$helper->fields_value['GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT'] = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT');
		$helper->fields_value['GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS'] = Configuration::get('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS');
		$helper->fields_value['GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED'] = Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED');
		$helper->fields_value['GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED'] = Configuration::get('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED');
		

		return $html . $helper->generateForm($fields_form);
	}

}