<?php


function GetStockLocation($productID, $productAttributeID)
{
	// 1. Check if product has a location in ps_warehouse_product_location
	$locationWarehouse = Db::getInstance()->getValue('SELECT location FROM '. _DB_PREFIX_.'warehouse_product_location WHERE id_product = '.$productID.' AND id_product_attribute='.$productAttributeID. ' ORDER BY id_warehouse');
	
	if ($locationWarehouse)
		return $locationWarehouse;


	// Check if we are in Prestashop 1.7
	$use17Location = (sizeof(Db::getInstance()->ExecuteS("SHOW COLUMNS FROM "._DB_PREFIX_."stock_available LIKE 'location'")) > 0);
	if ($use17Location)
	{
		return Db::getInstance()->getValue('SELECT location FROM '. _DB_PREFIX_.'stock_available WHERE id_product = '.$productID.' AND id_product_attribute='.$productAttributeID);
	}
	else
	{
		// Prestashop 1.6
		// Check if we have an attribute 
		if (isset($productAttributeID) && $productAttributeID != 0)
		{
			return Db::getInstance()->getValue('SELECT location FROM '. _DB_PREFIX_.'product_attribute WHERE id_product = '.$productID.' AND id_product_attribute='.$productAttributeID);
		}
		else
		{
			return Db::getInstance()->getValue('SELECT location FROM '. _DB_PREFIX_.'product WHERE id_product = '.$productID);
		}
	}
}

function GetLocationWeight($location)
{
	try {
		return Db::getInstance()->getValue('SELECT id_weight FROM '. _DB_PREFIX_."location_weight WHERE location = '".$location . "'");
	} catch (Exception $e) {
	}
	return 0; 
}

function GetSupplierReferences($productID, $productAttributeID)
{
	$result = array();
	$rows = Db::getInstance()->executeS('SELECT product_supplier_reference FROM '. _DB_PREFIX_.'product_supplier WHERE id_product = '.$productID.' AND id_product_attribute=' .$productAttributeID);
	foreach ($rows as $row)
	{
		array_push($result, $row["product_supplier_reference"]);
	}
	return $result;
}

class MissionDetail
{
	public $Label;
	public $Reference;
	public $StockLocation;
	public $Quantity;
	public $GTIN;
	public $SupplierReference;
	public $PickingIndex;
	
	public $Data1;
	public $Data2;
	public $Data3;
	public $Data4;
	public $Data5;
	public $Data6;
	public $Data7;
	public $Data8;
	
	public $NbSKUInPackage;
	public $PackageReference;
	public $NbSKUInPackage2;
	public $PackageReference2;
	
	public $PictureURL;
}

class ShippingDetail{
	public $ShippingCompany;
	public $ShippingLastname;
	public $ShippingFirstname;
	public $ShippingAddress1;
	public $ShippingAddress2;
	public $ShippingPostcode;
	public $ShippingCity;
	public $ShippingCountry;
	public $ShippingOther;
	public $ShippingPhone;
	public $ShippingMobilePhone;
	public $ShippingMail;
	public $ShippingVatnumber;
	public $ShippingDni;
	public $CarrierID;
	public $CarrierName;
	public $CarrierProductCode;
	public $CarrierTrackingNumber;
}

class Mission {
    public $Name;
    public $Info;
    public $DeleteWhenComplete;
	public $FinderKey;
	public $Details;
	public $ShippingDetails;
	public $Carrier;
	

	function __construct($Name) {
        $this->Name = $Name;
    }
	
	function LoadDetails()
	{
		$lang = Configuration::get('PS_LANG_DEFAULT');
		$referenceType = (int)Configuration::get('GOTOLIGHTCONNECTOR_REFERENCETYPE');

		// 1. extract mission info
		$rowOrder = Db::getInstance()->executeS('SELECT o.shipping_number, o.reference, ad.lastname, ad.firstname FROM '. _DB_PREFIX_.'orders o INNER JOIN '. _DB_PREFIX_.'address ad ON (ad.`id_address` = o.`id_address_delivery`) WHERE o.id_order = '.$this->Name.' ');

		$this->Info = $rowOrder[0]['reference'].' - '.$rowOrder[0]['firstname'].' '.$rowOrder[0]['lastname'];
		if ($rowOrder[0]['shipping_number'])
		{
			$this->FinderKey = $rowOrder[0]['shipping_number'];

			// TODO Create parameter for this ? Keep it ?
			// Special Hack for Colissimo (JCD logistique)
			// Remove last character of finder key because
			//$this->FinderKey = substr($this->FinderKey, 0, -1);
		}

		// 2. extract mission details
		$rowDetail = Db::getInstance()->executeS('SELECT od.product_ean13, od.product_reference, od.product_supplier_reference, od.product_id, od.product_attribute_id, od.product_quantity, od.product_name, p.cache_is_pack, p.qtyproductperpackage, p.gtinpackage, p.qtyproductperpackage2, p.gtinpackage2 FROM '. _DB_PREFIX_.'order_detail od INNER JOIN '. _DB_PREFIX_.'orders o ON o.id_order = od.id_order INNER JOIN '. _DB_PREFIX_.'product p ON p.id_product = od.product_id WHERE od.id_order = '.$this->Name.' ORDER BY od.product_name');

		$this->Details = array();

		foreach ($rowDetail as $detail)
		{
			$md = new MissionDetail();
			$md->Label = $detail['product_name'];

			if ($referenceType == 0)
				$md->Reference = $detail['product_reference'];
			else
				$md->Reference = $detail['product_ean13'];

			$md->GTIN = $detail['product_ean13'];
			$md->SupplierReference = $detail['product_supplier_reference'];
			
			$md->NbSKUInPackage = (int)$detail['qtyproductperpackage'];
			$md->PackageReference = $detail['gtinpackage'];	
			$md->NbSKUInPackage2 = (int)$detail['qtyproductperpackage2'];
			$md->PackageReference2 = $detail['gtinpackage2'];				
			
			// Extract supplier references
			$supplierReferences = GetSupplierReferences($detail['product_id'],$detail['product_attribute_id']);
			$md->Data1 = array_key_exists(0, $supplierReferences) ? $supplierReferences[0] : "";
			$md->Data2 = array_key_exists(1, $supplierReferences) ? $supplierReferences[1] : "";
			$md->Data3 = array_key_exists(2, $supplierReferences) ? $supplierReferences[2] : "";
			$md->Data4 = array_key_exists(3, $supplierReferences) ? $supplierReferences[3] : "";
			$md->Data5 = array_key_exists(4, $supplierReferences) ? $supplierReferences[4] : "";
			$md->Data6 = array_key_exists(5, $supplierReferences) ? $supplierReferences[5] : "";
			$md->Data7 = array_key_exists(6, $supplierReferences) ? $supplierReferences[6] : "";
			$md->Data8 = array_key_exists(7, $supplierReferences) ? $supplierReferences[7] : "";
			
			$md->Quantity = $detail['product_quantity'];
			$md->StockLocation = GetStockLocation($detail['product_id'],$detail['product_attribute_id']);
			$md->PickingIndex = GetLocationWeight($md->StockLocation);

			$md->PictureURL = generateImageLink($detail['product_id'], $lang);

			// Check if pack
			if ($detail['cache_is_pack'])
			{
				// Get pack composition
				$packDetails = Db::getInstance()->executeS('SELECT id_product_item,id_product_attribute_item,quantity FROM '. _DB_PREFIX_.'pack p WHERE p.id_product_pack = '.$detail['product_id']);

				// Get item name / reference
				foreach ($packDetails as $packDetail)
				{
					$mdPack = new MissionDetail();

					// Get declinaison if needed
					$label = Db::getInstance()->getValue('SELECT name FROM '. _DB_PREFIX_.'product_lang WHERE id_product = '.$packDetail['id_product_item']. ' AND id_lang = '.$lang);
					$mdPack->Label = $label;

					if ($packDetail['id_product_attribute_item'] != 0)
					{
						if ($referenceType == 0)
						{
							$reference = Db::getInstance()->getValue('SELECT reference FROM '. _DB_PREFIX_.'product_attribute  WHERE id_product = '.$packDetail['id_product_item'] . ' AND id_product_attribute = '.$packDetail['id_product_attribute_item']);
							$mdPack->Reference = $reference;
						}
						else
						{
							$ean13 = Db::getInstance()->getValue('SELECT ean13 FROM '. _DB_PREFIX_.'product_attribute  WHERE id_product = '.$packDetail['id_product_item'] . ' AND id_product_attribute = '.$packDetail['id_product_attribute_item']);
							$mdPack->Reference = $ean13;
						}

						// Get declinaison name
						$decLabel = Db::getInstance()->getValue('SELECT name FROM '. _DB_PREFIX_.'attribute_lang al INNER JOIN '. _DB_PREFIX_.'product_attribute_combination pac ON pac.id_attribute = al.id_attribute WHERE pac.id_product_attribute = '.$packDetail['id_product_attribute_item'] . ' AND al.id_lang = '.$lang);
						$mdPack->Label = $label.' - '.$decLabel;
						$mdPack->StockLocation = GetStockLocation($packDetail['id_product_item'],$packDetail['id_product_attribute_item']);
					}
					else
					{
						if ($referenceType == 0)
						{
							// No declinaison
							$reference = Db::getInstance()->getValue('SELECT p.reference FROM '. _DB_PREFIX_.'product p WHERE p.id_product = '.$packDetail['id_product_item']);
							$mdPack->Reference = $reference;
						}
						else
						{
							// No declinaison
							$ean13 = Db::getInstance()->getValue('SELECT p.ean13 FROM '. _DB_PREFIX_.'product p WHERE p.id_product = '.$packDetail['id_product_item']);
							$mdPack->Reference = $ean13;
						}

						$mdPack->Label = $label;
						$mdPack->StockLocation = GetStockLocation($packDetail['id_product_item'],0);
					}

					$mdPack->ImgURL = generateImageLink($packDetail['id_product_item'], $lang);
					$mdPack->Quantity = $packDetail['quantity'] * $detail['product_quantity'];

					array_push($this->Details, $mdPack);
				}
			}
			else
			{
				array_push($this->Details, $md);
			}
		}
	}
	
	function LoadShippingDetails(){
		
		$sd = new ShippingDetail();
		
		$checkDBExist = (sizeof(Db::getInstance()->executeS("SHOW TABLES LIKE '". _DB_PREFIX_."colissimo_order'")) > 0);
		$checkDBExist2 = (sizeof(Db::getInstance()->executeS("SHOW TABLES LIKE '". _DB_PREFIX_."dhldp_label'")) > 0);
		if($checkDBExist || checkDBExist2){
			//if there is a transport known for colissimo get all infos about shipping 
			$rowCarrierInfos = Db::getInstance()->executeS('SELECT co.id_colissimo_service, c.name, c.id_carrier, cs.product_code, cs.is_pickup, co.id_colissimo_pickup_point FROM '. _DB_PREFIX_.'colissimo_order co INNER JOIN '. _DB_PREFIX_.'orders o ON (o.id_order = co.id_order) INNER JOIN '. _DB_PREFIX_.'colissimo_service cs ON (cs.id_colissimo_service = co.id_colissimo_service) INNER JOIN '. _DB_PREFIX_.'carrier c ON (c.id_carrier = cs.id_carrier) WHERE o.id_order = '.$this->Name.' ');
			$rowCarrierInfos2 = Db::getInstance()->executeS('SELECT c.name, c.id_carrier FROM '. _DB_PREFIX_.'carrier c INNER JOIN '. _DB_PREFIX_.'orders o ON (o.id_carrier = c.id_carrier) WHERE o.id_order = '.$this->Name.' ');
			
			if($rowCarrierInfos[0]['name']){
				
				if($rowCarrierInfos[0]['is_pickup'] == 1){
					$rowPickupDetails = Db::getInstance()->executeS('SELECT cpp.company_name, cpp.address1, cpp.address2, cpp.zipcode, cpp.city, cpp.country, cpp.product_code FROM '. _DB_PREFIX_.'colissimo_pickup_point cpp  WHERE cpp.id_colissimo_pickup_point = '.$rowCarrierInfos[0]['id_colissimo_pickup_point'].' ');
					
					$rowShippingCustomer = Db::getInstance()->executeS('SELECT ad.lastname, ad.firstname FROM '. _DB_PREFIX_.'orders o INNER JOIN '. _DB_PREFIX_.'address ad ON (ad.`id_address` = o.`id_address_delivery`) WHERE o.id_order = '.$this->Name.' ');
					
					$sd->ShippingCompany = $rowPickupDetails[0]['company_name'];
					$sd->ShippingLastname = $rowShippingCustomer[0]['lastname'];
					$sd->ShippingFirstname = $rowShippingCustomer[0]['firstname'];
					$sd->ShippingAddress1 = $rowPickupDetails[0]['address1'];
					$sd->ShippingAddress2 = $rowPickupDetails[0]['address2'];
					$sd->ShippingPostcode = $rowPickupDetails[0]['zipcode'];
					$sd->ShippingCity = $rowPickupDetails[0]['city'];
					$sd->ShippingCountry = $rowPickupDetails[0]['country'];
					$sd->CarrierID = $rowCarrierInfos[0]['id_carrier'];
					$sd->CarrierName = $rowCarrierInfos[0]['name'];
					$sd->CarrierProductCode = $rowPickupDetails[0]['product_code'];
					
				}else{
					$rowShippingDetails = Db::getInstance()->executeS('SELECT ad.*, c.iso_code FROM '. _DB_PREFIX_.'orders o INNER JOIN '. _DB_PREFIX_.'address ad ON (ad.`id_address` = o.`id_address_delivery`) INNER JOIN '. _DB_PREFIX_.'country c ON (c.id_country = ad.id_country) WHERE o.id_order = '.$this->Name.' ');
				
					$sd->ShippingCompany = $rowShippingDetails[0]['company'];
					$sd->ShippingLastname = $rowShippingDetails[0]['lastname'];
					$sd->ShippingFirstname = $rowShippingDetails[0]['firstname'];
					$sd->ShippingAddress1 = $rowShippingDetails[0]['address1'];
					$sd->ShippingAddress2 = $rowShippingDetails[0]['address2'];
					$sd->ShippingPostcode = $rowShippingDetails[0]['postcode'];
					$sd->ShippingCity = $rowShippingDetails[0]['city'];
					$sd->ShippingOther = $rowShippingDetails[0]['other'];
					$sd->ShippingPhone = $rowShippingDetails[0]['phone'];
					$sd->ShippingMobilePhone = $rowShippingDetails[0]['phone_mobile'];
					$sd->ShippingVatnumber = $rowShippingDetails[0]['vat_umber'];
					$sd->ShippingCountry = $rowShippingDetails[0]['iso_code'];
					$sd->ShippingDni = $rowShippingDetails[0]['dni'];
					$sd->CarrierID = $rowCarrierInfos[0]['id_carrier'];
					$sd->CarrierName = $rowCarrierInfos[0]['name'];
					$sd->CarrierProductCode = $rowCarrierInfos[0]['product_code'];
				}
				
				$this->ShippingDetails = $sd;
				$this->Carrier = $rowCarrierInfos[0]['name'];
			}
			else if($rowCarrierInfos2[0]['name']){
				
				$rowShippingDetails2 = Db::getInstance()->executeS('SELECT ad.*, c.iso_code, cu.email FROM '. _DB_PREFIX_.'orders o INNER JOIN '. _DB_PREFIX_.'address ad ON (ad.`id_address` = o.`id_address_delivery`) INNER JOIN '. _DB_PREFIX_.'country c ON (c.id_country = ad.id_country) INNER JOIN '. _DB_PREFIX_.'customer cu ON (cu.id_customer = ad.id_customer) WHERE o.id_order = '.$this->Name.' ');
			
				$sd->ShippingCompany = $rowShippingDetails2[0]['company'];
				$sd->ShippingLastname = $rowShippingDetails2[0]['lastname'];
				$sd->ShippingFirstname = $rowShippingDetails2[0]['firstname'];
				$sd->ShippingAddress1 = $rowShippingDetails2[0]['address1'];
				$sd->ShippingAddress2 = $rowShippingDetails2[0]['address2'];
				$sd->ShippingPostcode = $rowShippingDetails2[0]['postcode'];
				$sd->ShippingCity = $rowShippingDetails2[0]['city'];
				$sd->ShippingOther = $rowShippingDetails2[0]['other'];
				$sd->ShippingPhone = $rowShippingDetails2[0]['phone'];
				$sd->ShippingMobilePhone = $rowShippingDetails2[0]['phone_mobile'];
				$sd->ShippingMail = $rowShippingDetails2[0]['email'];
				$sd->ShippingVatnumber = $rowShippingDetails2[0]['vat_umber'];
				$sd->ShippingCountry = $rowShippingDetails2[0]['iso_code'];
				$sd->ShippingDni = $rowShippingDetails2[0]['dni'];
				$sd->CarrierID = $rowCarrierInfos2[0]['id_carrier'];
				$sd->CarrierName = $rowCarrierInfos2[0]['name'];
				
				$this->ShippingDetails = $sd;
				$this->Carrier = $rowCarrierInfos2[0]['name'];
			}
		}
	}
}

function generateImageLink($product_id, $id_lang)
{
	$product = new Product((int)$product_id, false, $id_lang);
	$img = $product->getCover($product->id);
	$link = new Link();
	$img_url = $link->getImageLink($product->link_rewrite, (int)$img['id_image'], 'home_default');
	if (!startsWith($img_url, "http"))
		$img_url = "http://".$img_url;	

	return $img_url;
}

function startsWith( $haystack, $needle ) {
     $length = strlen( $needle );
     return substr( $haystack, 0, $length ) === $needle;
}

function API_GetRecentMissionNames()
{
	$excludeOneQuantity = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEONEQUANTITY');
	if ($excludeOneQuantity == '0')
		$excludeOneQuantity = null;
	
	$excludeQuantity = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEQUANTITY');
	if ($excludeQuantity == '0')
		$excludeQuantity = null;
	
	$excludeWeight = Configuration::get('GOTOLIGHTCONNECTOR_EXCLUDEWEIGHT');
	if ($excludeWeight == '0')
		$excludeWeight = null;	
	else
		$excludeWeight = str_replace(',', ".", $excludeWeight);	
	
	$query0 = "";
	$query1 = "";
	$query2 = "";
	$query3 = "";

	if (($excludeOneQuantity == true) || ($excludeQuantity != null) || ($excludeWeight != null)) $query0 = " AND id_order in (SELECT id_order FROM "._DB_PREFIX_."order_detail GROUP BY id_order HAVING id_order > 0 ";
	if ($excludeOneQuantity == true) $query1 = " AND SUM(product_quantity) > 1 ";
	if ($excludeQuantity != null) $query2 = " AND SUM(product_quantity) < ".$excludeQuantity." ";
	if ($excludeWeight != null) $query3 = " AND SUM(product_weight) < ".$excludeWeight." ";
	
	$sql = "";
	if (Configuration::get('GOTOLIGHTCONNECTOR_ADDORDERSTATUSTOEXPORT')){
		$sql = "SELECT a.`id_order` FROM "._DB_PREFIX_.'orders a WHERE a.current_state = '.Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT').' OR a.current_state = '.Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT2').' AND a.date_upd > (CURRENT_DATE() - INTERVAL 1 MONTH) ';
	}
	else{
		$sql = "SELECT a.`id_order` FROM "._DB_PREFIX_.'orders a WHERE a.current_state = '.Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSTOEXPORT').' AND a.date_upd > (CURRENT_DATE() - INTERVAL 1 MONTH) ';
	}

	if (($excludeOneQuantity == true) || ($excludeQuantity != null) || ($excludeWeight != null))
	$sql = $sql.$query0.$query1.$query2.$query3.")";

    $orders = Db::getInstance()->ExecuteS($sql);
    $answer = array();

    foreach ($orders as $order)
    {
        $mission = new Mission($order['id_order']);
        array_push($answer, $mission);
    }
	return json_encode($answer);
}

function API_GetRecentCancelledMissionNames()
{
	$sql = "SELECT a.`id_order` FROM "._DB_PREFIX_.'orders a WHERE (current_state = 6 OR current_state = 7) AND a.date_upd > (CURRENT_DATE() - INTERVAL 1 WEEK)';
	$orders = Db::getInstance()->ExecuteS($sql);
	$answer = array();
	foreach ($orders as $order)
	{
		$mission = new Mission($order['id_order']);
		array_push($answer, $mission);
	}
	return json_encode($answer);
}

function API_GetMissionsByNames($missionNames)
{
	$Names = json_decode($missionNames);

	$result = array();

	foreach ($Names as $Name)
	{
		$mission = new Mission($Name);
		$mission->LoadDetails();
		$mission->LoadShippingDetails();
		array_push($result, $mission);
	}
	return json_encode($result);
}

class CarrierSettings{
	public $SettingName;
	public $SettingValue;
	public $SettingLabel;
}

function API_GetColissimoSettings()
{
	$checkColissimoColumnsExist = (sizeof(Db::getInstance()->executeS("SHOW COLUMNS FROM ". _DB_PREFIX_."configuration WHERE name LIKE 'COLISSIMO_ACCOUNT_LOGIN'")) > 0);
	
	$result = array();
	if($checkColissimoColumnsExist){
		$configs = Db::getInstance()->ExecuteS("SELECT name, value FROM "._DB_PREFIX_."configuration WHERE name LIKE 'COLISSIMO_ACCOUNT%' OR name LIKE 'COLISSIMO_SENDER%'");
		
		foreach ($configs as $config)
		{
			$carrierSettings = new CarrierSettings();
			$carrierSettings->SettingName = $config['name'];
			$carrierSettings->SettingValue = $config['value'];
			$carrierSettings->SettingLabel = $config['name'];
			array_push($result, $carrierSettings);
		}
	}
	return json_encode($result);
}

function API_GetDHLSettings()
{
	$checkDHLColumnsExist = (sizeof(Db::getInstance()->executeS("SHOW COLUMNS FROM ". _DB_PREFIX_."configuration WHERE name LIKE 'DHLDP_DHL_ACCOUNT_OWNER'")) > 0);
	
	$result = array();
	if($checkDHLColumnsExist){
		$configs = Db::getInstance()->ExecuteS("SELECT name, value FROM "._DB_PREFIX_."configuration WHERE name LIKE 'DHLDP_DHL%'");
		
		foreach ($configs as $config)
		{
			$carrierSettings = new CarrierSettings();
			$carrierSettings->SettingName = $config['name'];
			$carrierSettings->SettingValue = $config['value'];
			$carrierSettings->SettingLabel = $config['name'];
			array_push($result, $carrierSettings);
		}
	}
	return json_encode($result);
}

class ProductStockInfo
{
	public $Label;
	public $Reference;
	public $ProductID;
	public $ProductAttributeID;
	public $StockLocation;
	public $Quantity;
	public $GTIN;
	public $GTIN_Attribute;
	public $NbSKUInPackage;
	public $PackageReference;
	public $NbSKUInPackage2;
	public $PackageReference2;
	public $Weight;
}

function API_GetStock()
{
	$excludeNonActiveProducts = Configuration::get('GOTOLIGHTCONNECTOR_STOCK_EXCLUDENONACTIVEPRODUCTS');
	$lang = Configuration::get('PS_LANG_DEFAULT');

	$use17Location = (sizeof(Db::getInstance()->ExecuteS("SHOW COLUMNS FROM "._DB_PREFIX_."stock_available LIKE 'location'")) > 0);
	if ($use17Location)
	{
		$sql = "SELECT pl.name, al.name as AttName, p.reference, p.ean13, p.id_product, pa.ean13 as ean13Att, sa.id_product_attribute, sa.quantity, sa.location, p.qtyproductperpackage, p.gtinpackage, p.qtyproductperpackage2, p.gtinpackage2, p.weight FROM "._DB_PREFIX_."stock_available sa ";
	}
	else
	{
		$sql = "SELECT pl.name, al.name as AttName, p.reference, p.ean13, p.id_product, sa.id_product_attribute, sa.quantity, pa.ean13 as ean13Att, p.location, pa.location as PALocation, p.qtyproductperpackage, p.gtinpackage, p.qtyproductperpackage2, p.gtinpackage2, p.weight FROM "._DB_PREFIX_."stock_available sa ";	
	}
	
	$sql .= "INNER JOIN "._DB_PREFIX_."product p ON sa.id_product = p.id_product 
	INNER JOIN "._DB_PREFIX_."product_lang pl ON sa.id_product = pl.id_product AND pl.id_lang = ".$lang."
	LEFT JOIN "._DB_PREFIX_."product_attribute pa ON pa.id_product = p.id_product AND pa.id_product_attribute = sa.id_product_attribute
	LEFT JOIN "._DB_PREFIX_."product_attribute_combination pac ON pac.id_product_attribute = sa.id_product_attribute
	LEFT JOIN "._DB_PREFIX_."attribute_lang al ON al.id_attribute = pac.id_attribute AND al.id_lang = ".$lang;

	if ($excludeNonActiveProducts != '0')
	{
		$sql .= " WHERE active = 1";
	}

	$stocks = Db::getInstance()->ExecuteS($sql);
	$answer = array();
	
	foreach ($stocks as $stockElement)
	{
		$psi = new ProductStockInfo();
		$psi->Label = $stockElement['name'];
		if (isset($stockElement['AttName']))
			$psi->Label .= " - " . $stockElement['AttName'];
		
		$psi->Reference = $stockElement['reference'];
		$psi->ProductID = $stockElement['id_product'];
		$psi->ProductAttributeID = $stockElement['id_product_attribute'];
		
		if (isset($stockElement['PALocation']))
			$psi->StockLocation = $stockElement['PALocation'];
		else
			$psi->StockLocation = $stockElement['location'];
				
		$psi->Quantity = $stockElement['quantity'];
		$psi->GTIN = $stockElement['ean13'];
		$psi->GTIN_Attribute = $stockElement['ean13Att'];
		
		$psi->NbSKUInPackage = (int)$stockElement['qtyproductperpackage'];
		$psi->PackageReference = $stockElement['gtinpackage'];	
		$psi->NbSKUInPackage2 = (int)$stockElement['qtyproductperpackage2'];
		$psi->PackageReference2 = $stockElement['gtinpackage2'];

		$psi->Weight = $stockElement['weight'];

		array_push($answer, $psi);
	}
	return json_encode($answer);
}

function API_SetStockLocation($psiJSON)
{
	$psi = json_decode($psiJSON);
	
	$use17Location = (sizeof(Db::getInstance()->ExecuteS("SHOW COLUMNS FROM "._DB_PREFIX_."stock_available LIKE 'location'")) > 0);
	
	if ($use17Location)
		Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."stock_available SET location = '".$psi->{'StockLocation'}."' WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	
	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."product SET location = '".$psi->{'StockLocation'}."' WHERE id_product = ".$psi->{'ProductID'});
	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."product_attribute SET location = '".$psi->{'StockLocation'}."' WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
}

function API_SetStockWeight($psiJSON)
{
	$psi = json_decode($psiJSON);
	
	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."product SET weight = ".$psi->{'Weight'}." WHERE id_product = ".$psi->{'ProductID'});
}

function API_SetStockEan($psiJSON){
	$psi = json_decode($psiJSON);
	
	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."product SET ean13 = ".$psi->{'GTIN'}." WHERE id_product = ".$psi->{'ProductID'});
}

function API_SetStockAbsoluteQuantity($psiJSON)
{
	$psi = json_decode($psiJSON);
	
	if ($psi->{'ProductAttributeID'} > 0)
	{
		// This is a product with variants: update also main qty
		// 1. Get Current quantities 
		$existingQtyAttribute = Db::getInstance()->getValue("SELECT quantity FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
		$delta = ((int)($psi->{'Quantity'})) - ((int)($existingQtyAttribute));
		$existingQtyMain = Db::getInstance()->getValue("SELECT quantity FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = 0");

		// 2. Update new main qty
		$newQtyMain = $existingQtyMain + $delta;
		
		Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."stock_available SET quantity = ".$newQtyMain." WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = 0");
	}

	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."stock_available SET quantity = ".$psi->{'Quantity'}." WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	
	// 3. Add stock MVT
	$StockID = Db::getInstance()->getValue("SELECT id_stock_available FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	
	if ($psi->{'Quantity'} > 0)
	{
		$id_stock_mvt_reason = 4;
		$sign = 1;
	}
	else
	{
		$id_stock_mvt_reason = 5;
		$sign = -1;
	}

	Db::getInstance()->Execute("INSERT INTO "._DB_PREFIX_."stock_mvt (id_stock,id_stock_mvt_reason,id_employee,employee_firstname,employee_lastname,physical_quantity,date_add,sign) VALUES (".$StockID.",".$id_stock_mvt_reason.",0,'','',".$psi->{'Quantity'}.",NOW(),".$sign.")");
}

function API_SetStockDeltaQuantity($psiJSON)
{
	$psi = json_decode($psiJSON);
	
	if ($psi->{'ProductAttributeID'} > 0)
	{
		// This is a product with variants: update also main qty
		// 1. Get Current quantities 
		$existingQtyMain = Db::getInstance()->getValue("SELECT quantity FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = 0");

		// 2. Update new main qty
		$newQtyMain = $existingQtyMain + $psi->{'Quantity'};
		Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."stock_available SET quantity = ".$newQtyMain." WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = 0");
	}
	
	$existingQtyAttribute = Db::getInstance()->getValue("SELECT quantity FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	$newQtyAttribute = $existingQtyAttribute + $psi->{'Quantity'};
	Db::getInstance()->Execute("UPDATE "._DB_PREFIX_."stock_available SET quantity = ".$newQtyAttribute." WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	
	
	// 3. Add stock MVT
	$StockID = Db::getInstance()->getValue("SELECT id_stock_available FROM "._DB_PREFIX_."stock_available WHERE id_product = ".$psi->{'ProductID'}." AND id_product_attribute = ".$psi->{'ProductAttributeID'});
	
	if ($psi->{'Quantity'} > 0)
	{
		$id_stock_mvt_reason = 1;
		$sign = 1;
	}
	else
	{
		$id_stock_mvt_reason = 2;
		$sign = -1;
	}

	Db::getInstance()->Execute("INSERT INTO "._DB_PREFIX_."stock_mvt (id_stock,id_stock_mvt_reason,id_employee,employee_firstname,employee_lastname,physical_quantity,date_add,sign) VALUES (".$StockID.",".$id_stock_mvt_reason.",0,'','',".$psi->{'Quantity'}.",NOW(),".$sign.")");
}

function API_StartMissions($missionIds, $employee)
{
    // Delete already completed/started mission status: could be improved with an history
	$sql = "DELETE FROM "._DB_PREFIX_."gotolightconnector_order_status WHERE id_order IN ('".implode("','", $missionIds)."')";
    Db::getInstance()->Execute($sql);
    
	foreach ($missionIds as $missionId) {
            $sql = 'INSERT INTO '._DB_PREFIX_. 'gotolightconnector_order_status (id_order, status, date_start, employee) VALUES (' .$missionId.",1, NOW(), '".$employee."')";
			Db::getInstance()->Execute($sql);
    }
}

function API_EndMissions($missionIds)
{
    foreach ($missionIds as $missionId) {
        $req = 'UPDATE '._DB_PREFIX_.'gotolightconnector_order_status SET date_finish = NOW(), Status = 2 WHERE id_order = '.$missionId;
		Db::getInstance()->Execute($req);
		
		// Update order status if needed with email sending
		if (Configuration::get('GOTOLIGHTCONNECTOR_CHANGEORDERSTATUSWHENPREPARED'))
		{
			$history = new OrderHistory();
			$history->id_order = (int)$missionId;
			$history->changeIdOrderState(Configuration::get('GOTOLIGHTCONNECTOR_ORDERSTATUSWHENPREPARED'), (int)$missionId);
			$history->add(true);
		}
    }
}

function API_PartialEndMissions($missionIds)
{
    foreach ($missionIds as $missionId) {
        $req = 'UPDATE '._DB_PREFIX_.'gotolightconnector_order_status SET date_finish = NOW(), Status = 3 WHERE id_order = '.$missionId;
		Db::getInstance()->Execute($req);
    }
}

function API_SetMissionTrackingNumber($MissionID, $TrackingNumber)
{	
	Db::getInstance()->Execute("UPDATE ". _DB_PREFIX_."order_carrier SET tracking_number = ". $TrackingNumber ." WHERE id_order = ".$MissionID);
}